/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class BlinkBlock
extends TranslatorBlock {
    public static final String ARDUBLOCK_BLINK_DEFINE = "void __ardublockBlink(int pinNumber)\n{\npinMode(pinNumber, OUTPUT);\ndigitalWrite(pinNumber, HIGH);\ndelay(1000);\ndigitalWrite(pinNumber, LOW);\ndelay(1000);\n}\n";

    public BlinkBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlock BlinkPin = this.getRequiredTranslatorBlockAtSocket(0);
        String pin = BlinkPin.toCode();
        String setupCode = "\tpinMode( " + pin + " , OUTPUT);";
        this.translator.addSetupCommand(setupCode);
        String ret = "\tdigitalWrite(" + pin + " , HIGH);\n";
        ret = ret + "\tdelay(1000);\n";
        ret = ret + "\tdigitalWrite(" + pin + " , LOW);\n";
        ret = ret + "\tdelay(1000);\n";
        return ret;
    }
}

