/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockConnectorShape;
import edu.mit.blocks.codeblocks.CustomBlockShapeSet;
import edu.mit.blocks.codeblocks.rendering.BlockShapeUtil;
import edu.mit.blocks.renderable.RenderableBlock;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class BlockShape {
    protected static BlockConnectorShape BCS = new BlockConnectorShape();
    protected static BlockShapeUtil BSU = new BlockShapeUtil();
    protected RenderableBlock rb;
    protected long blockID;
    protected Block block;
    private static ArrayList<CustomBlockShapeSet> customBlockShapeSets = new ArrayList();
    public static final float COMMAND_PORT_OFFSET = 15.0f;
    public static final float CORNER_RADIUS = 3.0f;
    public static final float VARIABLE_DECLARATION_SPACER = 10.0f;
    public static final float BOTTOM_SOCKET_SIDE_SPACER = 10.0f;
    public static final float BOTTOM_SOCKET_MIDDLE_SPACER = 16.0f;
    public static final float BOTTOM_SOCKET_UPPER_SPACER = 4.0f;
    private GeneralPath gpTop;
    private GeneralPath gpRight;
    protected GeneralPath gpBottom;
    private GeneralPath gpBottomClockwise;
    private GeneralPath gpLeft;
    private GeneralPath gpLeftClockwise;
    private Area blockArea;
    protected Rectangle blockBody;
    protected Point2D topLeftCorner;
    protected Point2D topRightCorner;
    protected Point2D botLeftCorner;
    protected Point2D botRightCorner;
    protected boolean hasCurvedCorners;
    protected float blockCornerRadius;

    public BlockShape(RenderableBlock rb) {
        if (rb != null) {
            this.rb = rb;
            this.blockID = rb.getBlockID();
            this.block = rb.getWorkspace().getEnv().getBlock(this.blockID);
        } else {
            System.out.println("Cannot create shape of null RenderableBlock.");
        }
        this.gpTop = new GeneralPath();
        this.gpRight = new GeneralPath();
        this.gpBottom = new GeneralPath();
        this.gpLeft = new GeneralPath();
        this.setupProperties();
    }

    private void setupProperties() {
        this.hasCurvedCorners = this.block.hasBeforeConnector() || this.block.hasAfterConnector() || this.block.isCommandBlock();
        this.blockCornerRadius = this.hasCurvedCorners ? 3.0f : 0.0f;
    }

    private void setupDimensions() {
        int initX = this.block.hasPlug() ? BlockConnectorShape.getConnectorDimensions((BlockConnector)this.block.getPlug()).width : 0;
        int initY = 0;
        Point2D[] cornerPoints = new Point2D[4];
        for (CustomBlockShapeSet customBlockShapeSet : customBlockShapeSets) {
            if (!customBlockShapeSet.checkCustomShapes(this.block, cornerPoints, this.rb.accomodateLabelsWidth(), this.getTotalHeightOfSockets())) continue;
            this.topLeftCorner = new Point2D.Double(cornerPoints[0].getX() + (double)initX, cornerPoints[0].getY() + (double)initY);
            this.topRightCorner = new Point2D.Double(cornerPoints[1].getX() + (double)initX, cornerPoints[1].getY() + (double)initY);
            this.botLeftCorner = new Point2D.Double(cornerPoints[2].getX() + (double)initX, cornerPoints[2].getY() + (double)initY);
            this.botRightCorner = new Point2D.Double(cornerPoints[3].getX() + (double)initX, cornerPoints[3].getY() + (double)initY);
            return;
        }
        int width = 0;
        int height = 0;
        width = this.determineBlockWidth();
        height = this.determineBlockHeight();
        this.blockBody = new Rectangle(initX, initY, width, height);
        this.topLeftCorner = new Point2D.Double(this.blockBody.getX(), this.blockBody.getY());
        this.topRightCorner = new Point2D.Double(this.blockBody.getX() + (double)this.blockBody.width, this.blockBody.getY());
        this.botLeftCorner = new Point2D.Double(this.blockBody.getX(), this.blockBody.getY() + this.blockBody.getHeight());
        this.botRightCorner = new Point2D.Double(this.blockBody.getX() + this.blockBody.getWidth(), this.blockBody.getY() + this.blockBody.getHeight());
    }

    protected int determineBlockWidth() {
        int width = 0;
        width += this.rb.accomodateLabelsWidth();
        width += this.rb.getMaxSocketShapeWidth();
        width = this.block.isCommandBlock() ? (width += 10) : (this.block.isDataBlock() || this.block.isFunctionBlock() ? (width += 8) : (this.block.isDeclaration() ? (width += 20) : (width += 10)));
        if (this.block.hasSiblings()) {
            width += 5;
        }
        if (width < this.rb.accomodateImagesWidth()) {
            width += this.rb.accomodateImagesWidth() - width + 10;
        }
        if (width % 2 == 1) {
            ++width;
        }
        width = Math.max(width, this.rb.getBlockWidgetDimension().width);
        return width;
    }

    protected int getTotalHeightOfSockets() {
        int heightSum = 0;
        boolean hasBottomSocket = false;
        int maxBottomSocketHeight = 0;
        for (BlockConnector socket : this.block.getSockets()) {
            Dimension socketDimension = this.rb.getSocketSpaceDimension(socket);
            if (socket.getPositionType() == BlockConnector.PositionType.BOTTOM) {
                if (socketDimension != null && socketDimension.height > maxBottomSocketHeight) {
                    maxBottomSocketHeight = socketDimension.height;
                }
                hasBottomSocket = true;
                continue;
            }
            if (socketDimension != null) {
                heightSum += socketDimension.height;
                if (!BlockConnectorShape.isCommandConnector(socket)) continue;
                heightSum = (int)((float)heightSum + 11.0f);
                continue;
            }
            if (BlockConnectorShape.isCommandConnector(socket)) {
                heightSum = (int)((float)heightSum + 35.0f);
                continue;
            }
            heightSum = (int)((float)heightSum + 24.0f);
        }
        if (hasBottomSocket) {
            heightSum += maxBottomSocketHeight;
        }
        return heightSum;
    }

    protected int determineBlockHeight() {
        int heightSum = 0;
        heightSum += (int)(this.hasCurvedCorners ? 6.0f : 0.0f);
        if ((float)(heightSum += this.getTotalHeightOfSockets()) < 24.0f) {
            heightSum = 24;
        }
        if ((heightSum += this.rb.accomodatePageLabelHeight()) < this.rb.accomodateImagesHeight()) {
            heightSum += this.rb.accomodateImagesHeight() - heightSum + 10;
        }
        if (this.block.isInfix()) {
            heightSum = (int)((float)heightSum + 4.0f);
        }
        heightSum = Math.max(heightSum, this.rb.getBlockWidgetDimension().height);
        return heightSum;
    }

    protected void makeTopSide() {
        this.setEndPoint(this.gpTop, this.topLeftCorner, this.botLeftCorner, true);
        BlockShapeUtil.cornerTo(this.gpTop, this.topLeftCorner, this.topRightCorner, this.blockCornerRadius);
        if (this.block.isCommandBlock() && this.block.hasBeforeConnector()) {
            Point2D p = BCS.addControlConnectorShape(this.gpTop, 15.0f + this.blockCornerRadius, true);
            this.rb.updateSocketPoint(this.block.getBeforeConnector(), p);
        }
        BlockShapeUtil.cornerTo(this.gpTop, this.topRightCorner, this.botRightCorner, this.blockCornerRadius);
        this.setEndPoint(this.gpTop, this.topRightCorner, this.botRightCorner, false);
    }

    protected void makeRightSide() {
        this.setEndPoint(this.gpRight, this.topRightCorner, this.botRightCorner, true);
        if (this.block.hasPageLabel()) {
            BlockShapeUtil.lineToRelative(this.gpRight, 0.0f, this.rb.accomodatePageLabelHeight() / 2);
        }
        if (this.block.getPlug() != null && this.block.getPlug().getPositionType().equals((Object)BlockConnector.PositionType.MIRROR)) {
            BCS.addDataPlug(this.gpRight, this.block.getPlug().getKind(), true);
        }
        for (BlockConnector curSocket : this.block.getSockets()) {
            if (!curSocket.getPositionType().equals((Object)BlockConnector.PositionType.SINGLE)) continue;
            if (BlockConnectorShape.isCommandConnector(curSocket)) {
                int spacerHeight = this.getSocketSpacerHeight(curSocket, 24.0f);
                Point2D p = BCS.addCommandSocket(this.gpRight, spacerHeight);
                this.rb.updateSocketPoint(curSocket, p);
                continue;
            }
            this.appendConnectorOffset(this.gpRight, this.topRightCorner, this.botRightCorner, curSocket, true);
            Point2D p = BCS.addDataSocket(this.gpRight, curSocket.getKind(), true);
            this.rb.updateSocketPoint(curSocket, p);
            int spacerHeight = this.getSocketSpacerHeight(curSocket, 24.0f);
            int socketHeight = BlockConnectorShape.getConnectorDimensions((BlockConnector)curSocket).height;
            BlockShapeUtil.lineToRelative(this.gpRight, 0.0f, spacerHeight - socketHeight);
            this.appendConnectorOffset(this.gpRight, this.topRightCorner, this.botRightCorner, curSocket, false);
        }
        this.setEndPoint(this.gpRight, this.botRightCorner, this.topRightCorner, false);
    }

    protected void makeLeftSide() {
        this.setEndPoint(this.gpLeft, this.topLeftCorner, this.botLeftCorner, true);
        if (this.block.getPlug() != null) {
            this.appendConnectorOffset(this.gpLeft, this.topLeftCorner, this.botLeftCorner, this.block.getPlug(), true);
            Point2D p = BCS.addDataPlug(this.gpLeft, this.block.getPlug().getKind(), false);
            this.rb.updateSocketPoint(this.block.getPlug(), p);
            this.appendConnectorOffset(this.gpLeft, this.topLeftCorner, this.botLeftCorner, this.block.getPlug(), false);
        }
        this.setEndPoint(this.gpLeft, this.botLeftCorner, this.topLeftCorner, false);
    }

    protected void makeBottomSide() {
        this.setEndPoint(this.gpBottom, this.botLeftCorner, this.topLeftCorner, true);
        BlockShapeUtil.cornerTo(this.gpBottom, this.botLeftCorner, this.botRightCorner, this.blockCornerRadius);
        if (this.block.hasAfterConnector() && !this.rb.isCollapsed()) {
            Point2D p = BCS.addControlConnectorShape(this.gpBottom, 15.0f + this.blockCornerRadius, true);
            this.rb.updateSocketPoint(this.block.getAfterConnector(), p);
        }
        BlockShapeUtil.cornerTo(this.gpBottom, this.botRightCorner, this.topRightCorner, this.blockCornerRadius);
        this.setEndPoint(this.gpBottom, this.botRightCorner, this.topRightCorner, false);
    }

    protected void setEndPoint(GeneralPath gp, Point2D currentCorner, Point2D otherCorner, boolean firstPointOnSide) {
        if (this.blockCornerRadius == 0.0f) {
            if (firstPointOnSide) {
                gp.moveTo((float)currentCorner.getX(), (float)currentCorner.getY());
            } else {
                gp.lineTo((float)currentCorner.getX(), (float)currentCorner.getY());
            }
        } else {
            double theta = Math.atan2(otherCorner.getX() - currentCorner.getX(), -(otherCorner.getY() - currentCorner.getY()));
            double dx = (double)this.blockCornerRadius * Math.cos(1.5707963267948966 - theta);
            double dy = (double)this.blockCornerRadius * Math.sin(1.5707963267948966 - theta);
            if (firstPointOnSide) {
                gp.moveTo((float)(currentCorner.getX() + dx), (float)(currentCorner.getY() - dy));
            } else {
                gp.lineTo((float)(currentCorner.getX() + dx), (float)(currentCorner.getY() - dy));
            }
        }
    }

    private void appendConnectorOffset(GeneralPath gp, Point2D topPoint, Point2D botPoint, BlockConnector blockConnector, boolean aboveConnector) {
        if (topPoint.getX() == botPoint.getX()) {
            return;
        }
        double Xdiff = topPoint.getX() - botPoint.getX();
        double Ydiff = Math.abs(topPoint.getY() - botPoint.getY());
        if (Xdiff > 0.0 && !aboveConnector) {
            return;
        }
        if (Xdiff < 0.0 && aboveConnector) {
            return;
        }
        double fraction = BlockConnectorShape.getConnectorDimensions(blockConnector).getHeight() / Ydiff;
        double insetDist = Xdiff * fraction;
        BlockShapeUtil.lineToRelative(gp, (float)(-insetDist), 0.0f);
    }

    protected int getSocketSpacerHeight(BlockConnector socket, float defaultHeight) {
        int spacerHeight = (int)defaultHeight;
        Dimension socketSpaceDimension = this.rb.getSocketSpaceDimension(socket);
        if (socketSpaceDimension != null) {
            spacerHeight = socketSpaceDimension.height;
        }
        return spacerHeight;
    }

    protected GeneralPath getBottomSide() {
        return this.gpBottomClockwise;
    }

    protected GeneralPath getLeftSide() {
        return this.gpLeftClockwise;
    }

    protected GeneralPath getTopSide() {
        return this.gpTop;
    }

    protected GeneralPath getRightSide() {
        return this.gpRight;
    }

    public Area reformArea() {
        this.gpTop.reset();
        this.gpRight.reset();
        this.gpBottom.reset();
        this.gpLeft.reset();
        this.setupDimensions();
        this.makeTopSide();
        this.makeRightSide();
        this.makeBottomSide();
        this.makeLeftSide();
        this.gpBottomClockwise = new GeneralPath();
        this.gpLeftClockwise = new GeneralPath();
        this.gpBottomClockwise.moveTo((float)this.gpBottom.getCurrentPoint().getX(), (float)this.gpBottom.getCurrentPoint().getY());
        this.gpLeftClockwise.moveTo((float)this.gpLeft.getCurrentPoint().getX(), (float)this.gpLeft.getCurrentPoint().getY());
        BlockShapeUtil.appendPath(this.gpBottomClockwise, this.gpBottom, true);
        BlockShapeUtil.appendPath(this.gpLeftClockwise, this.gpLeft, true);
        GeneralPath gpClockwise = new GeneralPath();
        GeneralPath gpCounterClockwise = new GeneralPath();
        gpCounterClockwise.append(this.gpLeft, true);
        gpCounterClockwise.append(this.gpBottom, true);
        gpClockwise.append(this.gpTop, true);
        gpClockwise.append(this.gpRight, true);
        BlockShapeUtil.appendPath(gpCounterClockwise, gpClockwise, true);
        this.blockArea = new Area(gpCounterClockwise);
        return this.blockArea;
    }

    public static void addCustomShapes(CustomBlockShapeSet cbs) {
        customBlockShapeSets.add(cbs);
    }
}

