/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;

public class CLabel
extends JLabel {
    private static final long serialVersionUID = 328149080212L;
    private final int[][] shadowPositionArray = new int[][]{{0, -1}, {1, -1}, {-1, 0}, {2, 0}, {-1, 1}, {1, 1}, {0, 2}, {1, 0}, {0, 1}};
    private final float[] shadowColorArray = new float[]{0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.0f, 0.0f};
    private double offsetSize = 1.0;

    public CLabel(String text) {
        super(text);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        String text = this.getText();
        if (text != null) {
            Font font = g2.getFont().deriveFont((float)((double)this.getHeight() * 0.8));
            g2.setFont(font);
            FontMetrics metrics = g2.getFontMetrics();
            Rectangle2D textBounds = metrics.getStringBounds(this.getText(), g2);
            double textHeight = textBounds.getHeight();
            double textWidth = textBounds.getWidth() > (double)this.getWidth() ? (double)(this.getWidth() / 2) : textBounds.getWidth();
            float x = (float)((double)(this.getWidth() / 2) - textWidth / 2.0);
            float y = (float)((double)(this.getHeight() / 2) + textHeight / 2.0) - (float)metrics.getDescent();
            g.setColor(Color.black);
            for (int i = 0; i < this.shadowPositionArray.length; ++i) {
                int dx = this.shadowPositionArray[i][0];
                int dy = this.shadowPositionArray[i][1];
                g2.setColor(new Color(0.5f, 0.5f, 0.5f, this.shadowColorArray[i]));
                g2.drawString(text, x + (float)((int)((double)dx * this.offsetSize)), y + (float)((int)((double)dy * this.offsetSize)));
            }
            g2.setColor(Color.white);
            g2.drawString(text, x, y);
        }
    }
}

