/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;

class HorizontalBar
extends JPanel
implements MouseListener,
MouseMotionListener {
    static final long serialVersionUID = 98231984183L;
    private final BoundedRangeModel modelrange;
    private final Color thumbColor;
    private final RenderingHints renderingHints;
    private int pressLocation;

    public HorizontalBar(int barwidth, Color thumbColor, BoundedRangeModel modelrange) {
        this.modelrange = modelrange;
        this.thumbColor = thumbColor;
        this.renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.pressLocation = 0;
        this.setMinimumSize(new Dimension(100, barwidth));
        this.setPreferredSize(new Dimension(100, barwidth));
        this.setBorder(null);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(this.renderingHints);
        g2.setColor(Color.gray);
        g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.getHeight(), this.getHeight());
        double viewValue = this.modelToView(this.modelrange.getValue());
        double viewExtent = this.modelToView(this.modelrange.getExtent());
        if (viewValue < (double)((float)this.getWidth() - 0.5f * (float)this.getHeight())) {
            g2.translate(viewValue, 0.0);
        } else {
            g2.translate((float)this.getWidth() - 0.5f * (float)this.getHeight(), 0.0);
        }
        g2.setColor(Color.lightGray);
        g2.setPaint(new GradientPaint(0.0f, 0.0f, this.thumbColor, 0.0f, this.getHeight() + 10, Color.black, true));
        g2.fill(this.reformThumbShape(this.getWidth(), this.getHeight(), (int)viewExtent));
    }

    private Shape reformThumbShape(int w, int h, int e) {
        if (e >= w - 2) {
            return new RoundRectangle2D.Double(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        if (e >= h) {
            RoundRectangle2D.Double shape = new RoundRectangle2D.Double(0.0, 0.0, e, h, h, h);
            return shape;
        }
        if ((float)e >= 0.5f * (float)h) {
            return new Ellipse2D.Float(0.0f, 0.0f, e, h);
        }
        return new Ellipse2D.Float(0.0f, 0.0f, e, 0.5f * (float)h);
    }

    private double viewToModel(int view) {
        return view * this.modelrange.getMaximum() / this.getWidth();
    }

    private double modelToView(int model) {
        return (double)(model * this.getWidth()) / (double)this.modelrange.getMaximum();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        double viewValue = this.modelToView(this.modelrange.getValue());
        double viewExtent = this.modelToView(this.modelrange.getExtent());
        if ((double)e.getX() < viewValue || (double)e.getX() > viewExtent + viewValue) {
            this.pressLocation = (int)(viewExtent / 2.0);
            this.modelrange.setValue((int)this.viewToModel(e.getX()) - this.modelrange.getExtent() / 2);
            this.repaint();
        } else {
            this.pressLocation = e.getX() - (int)viewValue;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.modelrange.setValue((int)this.viewToModel(e.getX() - this.pressLocation));
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.pressLocation = 0;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

