/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace.typeblocking;

import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.typeblocking.TypeBlockManager;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;

public class KeyInputMap {
    private static boolean DEFAULT_ENABLED = true;
    private static final Map<Character, String[]> defaultInputMap = new HashMap<Character, String[]>();
    private static final Map<Character, String[]> customInputMap = new HashMap<Character, String[]>();

    private KeyInputMap() {
    }

    protected static void enableDefaultKeyMapping(boolean enable) {
        DEFAULT_ENABLED = enable;
        char[] key = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '>', '<', '*', '/', '=', '\"', 'x', 'X', '|', '!', '&', '^'};
        String[][] value = new String[][]{{"number", "0"}, {"number", "1"}, {"number", "2"}, {"number", "3"}, {"number", "4"}, {"number", "5"}, {"number", "6"}, {"number", "7"}, {"number", "8"}, {"number", "9"}, {"sum", null}, {"greaterthan", null}, {"lessthan", null}, {"product", null}, {"quotient", null}, {"equals", null}, {"string", null}, {"product", null}, {"product", null}, {"or", null}, {"not", null}, {"and", null}, {"power", null}};
        for (int i = 0; i < key.length; ++i) {
            defaultInputMap.put(Character.valueOf(key[i]), value[i]);
        }
    }

    public static void processKeyChar(Workspace workspace, KeyEvent key) {
        if ((key.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            switch (key.getKeyCode()) {
                case 67: {
                    return;
                }
                case 86: {
                    return;
                }
                case 65: {
                    TypeBlockManager.automateCopyAll(workspace);
                    return;
                }
            }
            return;
        }
        if (key.isAltDown()) {
            // empty if block
        }
        if (key.isShiftDown() && key.getKeyCode() == 9) {
            TypeBlockManager.automateFocusTraversal(workspace, TypeBlockManager.Direction.LEFT);
            return;
        }
        switch (key.getKeyCode()) {
            case 127: {
                workspace.getTypeBlockManager().automateBlockDeletion(workspace);
                return;
            }
            case 8: {
                workspace.getTypeBlockManager().automateBlockDeletion(workspace);
                return;
            }
            case 40: {
                TypeBlockManager.automateFocusTraversal(workspace, TypeBlockManager.Direction.DOWN);
                return;
            }
            case 38: {
                TypeBlockManager.automateFocusTraversal(workspace, TypeBlockManager.Direction.UP);
                return;
            }
            case 37: {
                TypeBlockManager.automateFocusTraversal(workspace, TypeBlockManager.Direction.LEFT);
                return;
            }
            case 39: {
                TypeBlockManager.automateFocusTraversal(workspace, TypeBlockManager.Direction.RIGHT);
                return;
            }
            case 27: {
                TypeBlockManager.automateFocusTraversal(workspace, TypeBlockManager.Direction.ESCAPE);
                return;
            }
            case 10: {
                TypeBlockManager.automateFocusTraversal(workspace, TypeBlockManager.Direction.ENTER);
                return;
            }
            case 16: {
                return;
            }
            case 17: {
                return;
            }
            case 9: {
                TypeBlockManager.automateFocusTraversal(workspace, TypeBlockManager.Direction.RIGHT);
                return;
            }
        }
        if (DEFAULT_ENABLED) {
            if (key.getKeyChar() == '-') {
                workspace.getTypeBlockManager().automateNegationInsertion(workspace);
                return;
            }
            if (key.getKeyChar() == 'x' || key.getKeyChar() == 'X') {
                workspace.getTypeBlockManager().automateMultiplication(workspace, key.getKeyChar());
                return;
            }
            if (key.getKeyChar() == '+') {
                workspace.getTypeBlockManager().automateAddition(workspace, key.getKeyChar());
                return;
            }
            for (Character keyChar : defaultInputMap.keySet()) {
                if (!keyChar.equals(Character.valueOf(key.getKeyChar()))) continue;
                workspace.getTypeBlockManager().automateBlockInsertion(workspace, defaultInputMap.get(keyChar)[0], defaultInputMap.get(keyChar)[1]);
                return;
            }
        }
        for (Character keyChar : customInputMap.keySet()) {
            if (!keyChar.equals(Character.valueOf(key.getKeyChar()))) continue;
            workspace.getTypeBlockManager().automateBlockInsertion(workspace, customInputMap.get(keyChar)[0], customInputMap.get(keyChar)[1]);
            return;
        }
        if (Character.isLetterOrDigit(key.getKeyChar())) {
            workspace.getTypeBlockManager().automateAutoComplete(workspace, key.getKeyChar());
        } else {
            workspace.getTypeBlockManager().automateAutoComplete(workspace, key.getKeyChar());
        }
    }
}

