/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace.typeblocking;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockLink;
import edu.mit.blocks.codeblocks.BlockLinkChecker;
import edu.mit.blocks.renderable.BlockNode;
import edu.mit.blocks.renderable.BlockUtilities;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.renderable.TextualFactoryBlock;
import edu.mit.blocks.workspace.BlockCanvas;
import edu.mit.blocks.workspace.PageChangeEventManager;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceWidget;
import edu.mit.blocks.workspace.typeblocking.AutoCompletePanel;
import edu.mit.blocks.workspace.typeblocking.BlockDropAnimator;
import edu.mit.blocks.workspace.typeblocking.FocusTraversalManager;
import edu.mit.blocks.workspace.typeblocking.KeyInputMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class TypeBlockManager {
    private final Workspace workspace;
    private final AutoCompletePanel autoCompletePanel;
    private FocusTraversalManager focusManager;
    private BlockCanvas blockCanvas;
    static final String PLUS_OPERATION_LABEL = "+";
    static final String NUMBER_PLUS_OPERATION_LABEL = "+ [number]";
    static final String TEXT_PLUS_OPERATION_LABEL = "+ [text]";
    static final String EMPTY_LABEL_NAME = "";
    static final String QUOTE_LABEL = "\"";
    JFrame frame;
    private boolean enabled = false;
    private BlockNode bufferedBlock = null;

    public TypeBlockManager(Workspace workspace, BlockCanvas component) {
        this.workspace = workspace;
        KeyInputMap.enableDefaultKeyMapping(false);
        this.autoCompletePanel = new AutoCompletePanel(workspace);
        this.blockCanvas = component;
        this.focusManager = workspace.getFocusManager();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.blockCanvas.getCanvas().addMouseListener(this.focusManager);
            this.blockCanvas.getCanvas().addKeyListener(this.focusManager);
            this.workspace.addWorkspaceListener(this.focusManager);
        } else {
            this.blockCanvas.getCanvas().removeMouseListener(this.focusManager);
            this.blockCanvas.getCanvas().removeKeyListener(this.focusManager);
            this.workspace.removeWorkspaceListener(this.focusManager);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private static boolean invalidBlockID(Long blockID) {
        if (blockID == null) {
            return true;
        }
        return blockID.equals(Block.NULL);
    }

    private boolean isNullBlockInstance(Long blockID) {
        if (blockID == null) {
            return true;
        }
        if (blockID.equals(Block.NULL)) {
            return true;
        }
        if (this.workspace.getEnv().getBlock(blockID) == null) {
            return true;
        }
        if (this.workspace.getEnv().getBlock(blockID).getBlockID() == null) {
            return true;
        }
        if (this.workspace.getEnv().getBlock(blockID).getBlockID().equals(Block.NULL)) {
            return true;
        }
        if (this.workspace.getEnv().getRenderableBlock(blockID) == null) {
            return true;
        }
        if (this.workspace.getEnv().getRenderableBlock(blockID).getBlockID() == null) {
            return true;
        }
        return this.workspace.getEnv().getRenderableBlock(blockID).getBlockID().equals(Block.NULL);
    }

    protected void automateBlockDeletion(Workspace workspace) {
        TypeBlockManager typeBlockManager = workspace.getTypeBlockManager();
        if (!typeBlockManager.isEnabled()) {
            System.err.println("AutoMateBlockDeletion invoked but typeBlockManager is disabled.");
            return;
        }
        if (!this.isNullBlockInstance(typeBlockManager.focusManager.getFocusBlockID())) {
            typeBlockManager.deleteBlockAndChildren();
            PageChangeEventManager.notifyListeners();
        }
    }

    private void deleteBlockAndChildren() {
        if (this.isNullBlockInstance(this.focusManager.getFocusBlockID())) {
            throw new RuntimeException("TypeBlockManager: deleting a null block references.");
        }
        Block block = this.workspace.getEnv().getBlock(this.focusManager.getFocusBlockID());
        RenderableBlock renderable = this.workspace.getEnv().getRenderableBlock(block.getBlockID());
        WorkspaceWidget widget = renderable.getParentWidget();
        if (widget == null) {
            throw new RuntimeException("TypeBlockManager: do not delete blocks with no parent widget.");
        }
        Container container = renderable.getParent();
        if (container == null) {
            throw new RuntimeException("TypeBlockManager: do not delete blocks with no parent container.");
        }
        Point location = SwingUtilities.convertPoint(renderable, new Point(0, 0), this.blockCanvas.getCanvas());
        Long parentID = null;
        if (this.validConnection(block.getPlug())) {
            parentID = block.getPlugBlockID();
            this.disconnectBlock(block, widget);
            if (this.validConnection(block.getAfterConnector())) {
                this.disconnectBlock(this.workspace.getEnv().getBlock(block.getAfterBlockID()), widget);
            }
        } else if (this.validConnection(block.getBeforeConnector())) {
            parentID = block.getBeforeBlockID();
            BlockConnector parentConnectorToBlock = this.workspace.getEnv().getBlock(parentID).getConnectorTo(block.getBlockID());
            this.disconnectBlock(block, widget);
            if (this.validConnection(block.getAfterConnector())) {
                BlockLink link;
                Long afterBlockID = block.getAfterBlockID();
                this.disconnectBlock(this.workspace.getEnv().getBlock(afterBlockID), widget);
                if (parentID != null && (link = BlockLinkChecker.canLink(this.workspace, this.workspace.getEnv().getBlock(parentID), this.workspace.getEnv().getBlock(afterBlockID), parentConnectorToBlock, this.workspace.getEnv().getBlock(afterBlockID).getBeforeConnector())) != null) {
                    link.connect();
                    this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, this.workspace.getEnv().getRenderableBlock(link.getPlugBlockID()).getParentWidget(), link, 5));
                    this.workspace.getEnv().getRenderableBlock(link.getPlugBlockID()).repaintBlock();
                    this.workspace.getEnv().getRenderableBlock(link.getPlugBlockID()).repaint();
                    this.workspace.getEnv().getRenderableBlock(link.getPlugBlockID()).moveConnectedBlocks();
                    this.workspace.getEnv().getRenderableBlock(link.getSocketBlockID()).repaintBlock();
                    this.workspace.getEnv().getRenderableBlock(link.getSocketBlockID()).repaint();
                }
            }
        } else if (this.validConnection(block.getAfterConnector())) {
            parentID = block.getAfterBlockID();
        }
        this.removeChildrenBlock(renderable, widget, container);
        if (TypeBlockManager.invalidBlockID(parentID)) {
            this.focusManager.setFocus(location, Block.NULL);
            this.blockCanvas.getCanvas().requestFocus();
            return;
        }
        this.focusManager.setFocus(parentID);
        this.blockCanvas.getCanvas().requestFocus();
    }

    private void removeChildrenBlock(RenderableBlock renderable, WorkspaceWidget widget, Container container) {
        widget.removeBlock(renderable);
        container.remove(renderable);
        container.validate();
        container.repaint();
        renderable.setParentWidget(null);
        for (BlockConnector child : this.workspace.getEnv().getBlock(renderable.getBlockID()).getSockets()) {
            RenderableBlock childRenderable;
            if (child == null || child.getBlockID().equals(Block.NULL) || (childRenderable = this.workspace.getEnv().getRenderableBlock(child.getBlockID())) == null) continue;
            this.removeBlock(childRenderable, widget, container);
        }
        if (this.workspace.getEnv().getBlock(renderable.getBlockID()).isProcedureDeclBlock() && this.workspace.getEnv().getBlock(renderable.getBlockID()).getAfterBlockID() != Block.NULL) {
            this.removeAfterBlock(this.workspace.getEnv().getRenderableBlock(this.workspace.getEnv().getBlock(renderable.getBlockID()).getAfterBlockID()), widget, container);
            this.disconnectBlock(this.workspace.getEnv().getBlock(this.workspace.getEnv().getBlock(renderable.getBlockID()).getAfterBlockID()), widget);
        }
        if (renderable.hasComment()) {
            renderable.removeComment();
        }
        this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, widget, renderable.getBlockID(), 4));
    }

    private void removeAfterBlock(RenderableBlock afterBlock, WorkspaceWidget widget, Container container) {
        if (this.workspace.getEnv().getBlock(afterBlock.getBlockID()).getAfterBlockID() != Block.NULL) {
            this.removeAfterBlock(this.workspace.getEnv().getRenderableBlock(this.workspace.getEnv().getBlock(afterBlock.getBlockID()).getAfterBlockID()), widget, container);
        }
        this.removeChildrenBlock(afterBlock, widget, container);
    }

    private boolean validConnection(BlockConnector connection) {
        Long blockID;
        return connection != null && !this.isNullBlockInstance(blockID = connection.getBlockID()) && connection.hasBlock();
    }

    private void removeBlock(RenderableBlock renderable, WorkspaceWidget widget, Container container) {
        widget.removeBlock(renderable);
        container.remove(renderable);
        container.validate();
        container.repaint();
        renderable.setParentWidget(null);
        for (BlockConnector child : BlockLinkChecker.getSocketEquivalents(this.workspace.getEnv().getBlock(renderable.getBlockID()))) {
            RenderableBlock childRenderable;
            if (child == null || child.getBlockID().equals(Block.NULL) || (childRenderable = this.workspace.getEnv().getRenderableBlock(child.getBlockID())) == null) continue;
            this.removeBlock(childRenderable, widget, container);
        }
        if (renderable.hasComment()) {
            renderable.removeComment();
        }
        this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, widget, renderable.getBlockID(), 4));
    }

    private void disconnectBlock(Block childBlock, WorkspaceWidget widget) {
        if (childBlock == null || TypeBlockManager.invalidBlockID(childBlock.getBlockID())) {
            return;
        }
        BlockConnector childPlug = BlockLinkChecker.getPlugEquivalent(childBlock);
        if (childPlug == null || !childPlug.hasBlock() || this.isNullBlockInstance(childPlug.getBlockID())) {
            return;
        }
        Block parentBlock = this.workspace.getEnv().getBlock(childPlug.getBlockID());
        BlockConnector parentSocket = parentBlock.getConnectorTo(childBlock.getBlockID());
        if (parentSocket == null) {
            return;
        }
        BlockLink link = BlockLink.getBlockLink(this.workspace, childBlock, parentBlock, childPlug, parentSocket);
        if (link == null) {
            return;
        }
        link.disconnect();
        RenderableBlock parentRenderable = this.workspace.getEnv().getRenderableBlock(parentBlock.getBlockID());
        if (parentRenderable == null) {
            throw new RuntimeException("INCONSISTANCY VIOLATION: parent block was valid, non-null, and existed.\n\tBut yet, when we get it's renderablerepresentation, we recieve a null instance.\n\tIf the Block instance of an ID is non-nullthen its graphical RenderableBlock should be non-null as well");
        }
        parentRenderable.blockDisconnected(parentSocket);
        this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, widget, link, 6));
    }

    public static void copyBlock(Workspace workspace) {
        TypeBlockManager.automateCopyBlock(workspace);
    }

    public static void pasteBlock(Workspace workspace) {
        TypeBlockManager.automatePasteBlock(workspace);
    }

    protected static void automateCopyBlock(Workspace workspace) {
        TypeBlockManager typeBlockManager = workspace.getTypeBlockManager();
        if (!typeBlockManager.isEnabled()) {
            System.err.println("AutoMateCopyBlock invoked but typeBlockManager is disabled.");
            return;
        }
        typeBlockManager.bufferedBlock = BlockUtilities.makeNodeWithChildren(workspace, typeBlockManager.focusManager.getFocusBlockID());
    }

    protected static void automateCopyAll(Workspace workspace) {
        TypeBlockManager typeBlockManager = workspace.getTypeBlockManager();
        if (!typeBlockManager.isEnabled()) {
            System.err.println("AutoMatePasteBlock invoked but typeBlockManager is disabled.");
            return;
        }
        typeBlockManager.bufferedBlock = BlockUtilities.makeNodeWithStack(workspace, typeBlockManager.focusManager.getFocusBlockID());
    }

    protected static void automatePasteBlock(Workspace workspace) {
        TypeBlockManager typeBlockManager = workspace.getTypeBlockManager();
        if (!typeBlockManager.isEnabled()) {
            System.err.println("AutoMatePasteBlock invoked but typeBlockManager is disabled.");
            return;
        }
        typeBlockManager.pasteStack(typeBlockManager.bufferedBlock);
    }

    private void pasteStack(BlockNode node) {
        if (node == null) {
            return;
        }
        WorkspaceWidget widget = null;
        Object widgets = null;
        Point spot = null;
        if (TypeBlockManager.invalidBlockID(this.focusManager.getFocusBlockID())) {
            Point location = SwingUtilities.convertPoint(this.blockCanvas.getCanvas(), this.focusManager.getCanvasPoint(), this.workspace);
            widget = this.workspace.getWidgetAt(location);
            spot = SwingUtilities.convertPoint(this.blockCanvas.getCanvas(), this.focusManager.getCanvasPoint(), widget.getJComponent());
        } else {
            RenderableBlock focusRenderable = this.workspace.getEnv().getRenderableBlock(this.focusManager.getFocusBlockID());
            widget = focusRenderable.getParentWidget();
            spot = focusRenderable.getLocation();
        }
        if (widget == null) {
            JOptionPane.showMessageDialog(this.frame, "Please click somewhere on the canvas first.", "Error", -1);
        } else if (BlockUtilities.blockExists(this.workspace, node)) {
            spot.translate(10, 10);
            RenderableBlock mirror = BlockUtilities.makeRenderable(this.workspace, node, widget);
            mirror.setLocation(spot);
            mirror.moveConnectedBlocks();
        } else {
            JOptionPane.showMessageDialog(this.frame, "You cannot paste blocks that are currently NOT on the canvas.\nThis function will be available in a future version.\n", "Error", -1);
        }
    }

    protected static void automateFocusTraversal(Workspace workspace, Direction dir) {
        TypeBlockManager typeBlockManager = workspace.getTypeBlockManager();
        if (!typeBlockManager.isEnabled()) {
            System.err.println("AutoMateFocusTraversal invoked but typeBlockManager is disabled.");
            return;
        }
        typeBlockManager.traverseFocus(dir);
    }

    private void traverseFocus(Direction dir) {
        if (this.isNullBlockInstance(this.focusManager.getFocusBlockID())) {
            if (dir == Direction.UP) {
                this.blockCanvas.getVerticalModel().setValue(this.blockCanvas.getVerticalModel().getValue() - 5);
            } else if (dir == Direction.DOWN) {
                this.blockCanvas.getVerticalModel().setValue(this.blockCanvas.getVerticalModel().getValue() + 5);
            } else if (dir == Direction.LEFT) {
                this.blockCanvas.getHorizontalModel().setValue(this.blockCanvas.getHorizontalModel().getValue() - 5);
            } else if (dir == Direction.RIGHT) {
                this.blockCanvas.getHorizontalModel().setValue(this.blockCanvas.getHorizontalModel().getValue() + 5);
            } else if (dir == Direction.ESCAPE) {
                this.blockCanvas.getCanvas().requestFocus();
            } else if (dir == Direction.ENTER) {
                // empty if block
            }
        } else if (dir == Direction.UP) {
            this.focusManager.focusBeforeBlock();
        } else if (dir == Direction.DOWN) {
            this.focusManager.focusAfterBlock();
        } else if (dir == Direction.LEFT) {
            this.focusManager.focusPrevBlock();
        } else if (dir == Direction.RIGHT) {
            this.focusManager.focusNextBlock();
        } else if (dir == Direction.ESCAPE) {
            RenderableBlock block = this.workspace.getEnv().getRenderableBlock(this.focusManager.getFocusBlockID());
            Point location = SwingUtilities.convertPoint(block, new Point(0, 0), this.blockCanvas.getCanvas());
            this.focusManager.setFocus(location, Block.NULL);
            this.blockCanvas.getCanvas().requestFocus();
        } else if (dir == Direction.ENTER) {
            this.workspace.getEnv().getRenderableBlock(this.focusManager.getFocusBlockID()).switchToLabelEditingMode(true);
        }
    }

    protected void automateAutoComplete(Workspace workspace, char character) {
        TypeBlockManager typeBlockManager = workspace.getTypeBlockManager();
        if (!typeBlockManager.isEnabled()) {
            System.err.println("AutoMateAutoComplete invoked but typeBlockManager is disabled.");
            return;
        }
        typeBlockManager.displayAutoCompletePanel(character);
    }

    private void displayAutoCompletePanel(char character) {
        if (TypeBlockManager.invalidBlockID(this.focusManager.getFocusBlockID())) {
            this.blockCanvas.getCanvas().add((Component)this.autoCompletePanel, JLayeredPane.DRAG_LAYER);
            this.autoCompletePanel.setLocation(this.focusManager.getCanvasPoint());
            this.autoCompletePanel.setVisible(true);
            this.autoCompletePanel.requestFocus();
        } else {
            this.blockCanvas.getCanvas().add((Component)this.autoCompletePanel, JLayeredPane.DRAG_LAYER);
            RenderableBlock block = this.workspace.getEnv().getRenderableBlock(this.focusManager.getFocusBlockID());
            Point location = SwingUtilities.convertPoint(block, this.focusManager.getBlockPoint(), this.blockCanvas.getCanvas());
            location.translate(10, 10);
            this.autoCompletePanel.setLocation(location);
            this.autoCompletePanel.setVisible(true);
            this.autoCompletePanel.requestFocus();
        }
        this.autoCompletePanel.setText(String.valueOf(character));
    }

    protected void automateNegationInsertion(Workspace workspace) {
        TypeBlockManager typeBlockManager = workspace.getTypeBlockManager();
        if (!typeBlockManager.isEnabled()) {
            System.err.println("AutoMateNegationInsertion invoked but typeBlockManager is disabled.");
            return;
        }
        Long parentBlockID = typeBlockManager.focusManager.getFocusBlockID();
        if (this.isNullBlockInstance(parentBlockID)) {
            this.automateBlockInsertion(workspace, "number", "-");
        } else {
            Block parentBlock = workspace.getEnv().getBlock(parentBlockID);
            if (parentBlock.isDataBlock()) {
                this.automateBlockInsertion(workspace, "difference", null);
            } else {
                this.automateBlockInsertion(workspace, "number", "-");
            }
        }
    }

    protected void automateMultiplication(Workspace workspace, char character) {
        Block parentBlock;
        TypeBlockManager typeBlockManager = workspace.getTypeBlockManager();
        if (!typeBlockManager.isEnabled()) {
            System.err.println("AutoMateMultiplication invoked but typeBlockManager is disabled.");
            return;
        }
        if (!this.isNullBlockInstance(typeBlockManager.focusManager.getFocusBlockID()) && (parentBlock = workspace.getEnv().getBlock(typeBlockManager.focusManager.getFocusBlockID())).getGenusName().equals("number")) {
            this.automateBlockInsertion(workspace, "product", null);
            return;
        }
        this.automateAutoComplete(workspace, character);
    }

    protected void automateAddition(Workspace workspace, char character) {
        TypeBlockManager typeBlockManager = workspace.getTypeBlockManager();
        if (!typeBlockManager.isEnabled()) {
            System.err.println("AutoMateMultiplication invoked but typeBlockManager is disabled.");
            return;
        }
        Long parentBlockID = typeBlockManager.focusManager.getFocusBlockID();
        if (this.isNullBlockInstance(parentBlockID)) {
            this.automateBlockInsertion(workspace, "sum", null);
        } else {
            Block parentBlock = workspace.getEnv().getBlock(parentBlockID);
            if (parentBlock.getGenusName().equals("string")) {
                this.automateBlockInsertion(workspace, "string-append", null);
            } else if (parentBlock.getGenusName().equals("string-append")) {
                this.automateBlockInsertion(workspace, "string-append", null);
            } else {
                this.automateBlockInsertion(workspace, "sum", null);
            }
        }
    }

    protected void automateBlockInsertion(Workspace workspace, String genusName, String label) {
        TypeBlockManager typeBlockManager = workspace.getTypeBlockManager();
        if (!typeBlockManager.isEnabled()) {
            System.err.println("AutoMateBlockInsertion invoked but typeBlockManager is disabled.");
            return;
        }
        if (genusName == null) {
            return;
        }
        RenderableBlock createdRB = BlockUtilities.getBlock(workspace, genusName, null);
        if (createdRB == null) {
            return;
        }
        if (label != null && workspace.getEnv().getBlock(createdRB.getBlockID()).isLabelEditable() && !workspace.getEnv().getBlock(createdRB.getBlockID()).labelMustBeUnique()) {
            workspace.getEnv().getBlock(createdRB.getBlockID()).setBlockLabel(label);
        }
        typeBlockManager.addBlock(createdRB);
    }

    protected void automateBlockInsertion(Workspace workspace, TextualFactoryBlock block) {
        this.automateBlockInsertion(workspace, block, EMPTY_LABEL_NAME);
    }

    protected void automateBlockInsertion(Workspace workspace, TextualFactoryBlock block, String label) {
        TypeBlockManager typeBlockManager = workspace.getTypeBlockManager();
        if (!typeBlockManager.isEnabled()) {
            System.err.println("AutoMateBlockInsertion invoked but typeBlockManager is disabled.");
            return;
        }
        RenderableBlock createdRB = this.createRenderableBlock(block);
        if (label != EMPTY_LABEL_NAME) {
            createdRB.getBlock().setBlockLabel(label);
        }
        if (label.equals(NUMBER_PLUS_OPERATION_LABEL)) {
            createdRB.getBlock().setBlockLabel(PLUS_OPERATION_LABEL);
        }
        if (label.equals(TEXT_PLUS_OPERATION_LABEL)) {
            createdRB.getBlock().setBlockLabel(PLUS_OPERATION_LABEL);
        }
        if (createdRB == null) {
            return;
        }
        typeBlockManager.addBlock(createdRB);
    }

    private RenderableBlock createRenderableBlock(TextualFactoryBlock block) {
        if (block == null) {
            return null;
        }
        if (block.getfactoryBlock() == null || block.getfactoryBlock().getBlockID().equals(Block.NULL)) {
            return null;
        }
        RenderableBlock createdRB = block.getfactoryBlock().createNewInstance();
        if (createdRB == null || this.isNullBlockInstance(createdRB.getBlockID())) {
            throw new RuntimeException("Invariant Violated:May not drop null instances of Renderable Blocks");
        }
        return createdRB;
    }

    private void addBlock(RenderableBlock block) {
        if (block == null || block.getBlockID() == null || block.getBlockID().equals(Block.NULL) || this.workspace.getEnv().getBlock(block.getBlockID()) == null || this.workspace.getEnv().getBlock(block.getBlockID()).getGenusName() == null || this.workspace.getEnv().getBlock(block.getBlockID()).getGenusName().length() == 0 || this.workspace.getEnv().getBlock(block.getBlockID()).getBlockLabel() == null) {
            throw new RuntimeException("Invariant Violated: may not pass an invalid instance of renderabel block");
        }
        block.ignoreDefaultArguments();
        this.blockCanvas.getCanvas().add((Component)block, 0);
        block.setLocation(0, 0);
        Long parentBlockID = this.focusManager.getFocusBlockID();
        if (TypeBlockManager.invalidBlockID(parentBlockID)) {
            new BlockDropAnimator(this.workspace, this.focusManager.getCanvasPoint(), block, this.workspace.getEnv().getRenderableBlock(parentBlockID));
        } else {
            RenderableBlock parentBlock = this.workspace.getEnv().getRenderableBlock(parentBlockID);
            new BlockDropAnimator(this.workspace, SwingUtilities.convertPoint(parentBlock, this.focusManager.getBlockPoint(), this.blockCanvas.getCanvas()), block, this.workspace.getEnv().getRenderableBlock(parentBlockID));
        }
        this.focusManager.setFocus(block.getBlockID());
    }

    protected static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        ESCAPE,
        ENTER;

    }
}

